/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.google.inject.Inject;
import java.util.Map;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureTypeDictionary;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;

public class FurnitureViewerUI
implements Disposable {
    private final EntityAssetUpdater entityAssetUpdater;
    private Skin uiSkin = new Skin(Gdx.files.internal("assets/ui-skins/libgdx-default/uiskin.json"));
    private Stage stage;
    private Table containerTable;
    private TextButton backgroundMatButton;
    private TextButton mainMatButton;
    private TextButton seedButton;
    private Entity currentEntity;
    private Map<EntityAssetType, EntityAsset> assetMap;
    private FurnitureEntityAttributes entityAttributes;
    private final EntityAssetTypeDictionary assetTypeDictionary;
    private final FurnitureTypeDictionary furnitureTypeDictionary;
    private final GameMaterialDictionary gameMaterialDictionary;
    private final PlantSpeciesDictionary plantSpeciesDictionary;

    @Inject
    public FurnitureViewerUI(EntityAssetTypeDictionary assetTypeDictionary, EntityAssetUpdater entityAssetUpdater, FurnitureTypeDictionary furnitureTypeDictionary, GameMaterialDictionary gameMaterialDictionary, PlantSpeciesDictionary plantSpeciesDictionary) {
        this.assetTypeDictionary = assetTypeDictionary;
        this.furnitureTypeDictionary = furnitureTypeDictionary;
        this.gameMaterialDictionary = gameMaterialDictionary;
        this.plantSpeciesDictionary = plantSpeciesDictionary;
        this.entityAssetUpdater = entityAssetUpdater;
        this.stage = new Stage(new ScreenViewport());
        this.containerTable = new Table(this.uiSkin);
        this.containerTable.setFillParent(true);
        this.stage.addActor(this.containerTable);
        this.containerTable.pad(20.0f);
        this.containerTable.left().top();
    }

    public void init(Entity entity) {
        this.currentEntity = entity;
        this.entityAttributes = (FurnitureEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        this.assetMap = entity.getPhysicalEntityComponent().getTypeMap();
        this.containerTable.clearChildren();
        this.createFurnitureTypeWidget();
        this.containerTable.row();
        this.createPrimaryMaterialWidget();
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.STONE);
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.WOOD);
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.ORE);
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.GEM);
        this.containerTable.row();
        this.createRotateWidget();
        this.containerTable.row();
        this.createSeedWidget();
        this.containerTable.row();
    }

    private void createSeedWidget() {
        this.containerTable.add(new Label((CharSequence)"Seed: ", this.uiSkin));
        this.seedButton = new TextButton("#0", this.uiSkin);
        this.seedButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                long nextSeed = FurnitureViewerUI.this.entityAttributes.getSeed() + 1L;
                FurnitureViewerUI.this.entityAttributes.setSeed(nextSeed);
                FurnitureViewerUI.this.entityAssetUpdater.updateEntityAssets(FurnitureViewerUI.this.currentEntity);
                FurnitureViewerUI.this.seedButton.setText("#" + nextSeed);
            }
        });
        this.containerTable.add(this.seedButton);
    }

    private void createRotateWidget() {
        this.containerTable.add(new Label((CharSequence)"Rotate: ", this.uiSkin));
        this.seedButton = new TextButton("Rotate me!", this.uiSkin);
        this.seedButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FurnitureLayout currentLayout = FurnitureViewerUI.this.entityAttributes.getCurrentLayout();
                if (currentLayout.getRotatesTo() != null) {
                    FurnitureViewerUI.this.entityAttributes.setCurrentLayout(currentLayout.getRotatesTo());
                    FurnitureViewerUI.this.entityAssetUpdater.updateEntityAssets(FurnitureViewerUI.this.currentEntity);
                }
            }
        });
        this.containerTable.add(this.seedButton);
    }

    private void createPrimaryMaterialWidget() {
        final SelectBox typeSelect = new SelectBox(this.uiSkin);
        Array<GameMaterialType> types = new Array<GameMaterialType>();
        types.add(GameMaterialType.METAL);
        types.add(GameMaterialType.STONE);
        types.add(GameMaterialType.WOOD);
        Array<String> typeNames = new Array<String>();
        for (GameMaterialType type : types) {
            typeNames.add(type.name());
        }
        typeSelect.setItems(typeNames);
        typeSelect.setSelected(this.entityAttributes.getPrimaryMaterialType().name());
        typeSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String selectedTypeName = (String)typeSelect.getSelected();
                GameMaterialType selectedType = GameMaterialType.valueOf(selectedTypeName);
                FurnitureViewerUI.this.entityAttributes.setPrimaryMaterialType(selectedType);
                FurnitureViewerUI.this.entityAssetUpdater.updateEntityAssets(FurnitureViewerUI.this.currentEntity);
            }
        });
        this.containerTable.add(new Label((CharSequence)"Material Type:", this.uiSkin), typeSelect);
    }

    private void createFurnitureTypeWidget() {
        final SelectBox itemTypeSelect = new SelectBox(this.uiSkin);
        Array<String> furnitureTypeNames = new Array<String>();
        for (FurnitureType itemType : this.furnitureTypeDictionary.getAll()) {
            if (itemType.getName().contains("Null")) continue;
            furnitureTypeNames.add(itemType.getName());
        }
        itemTypeSelect.setItems(furnitureTypeNames);
        itemTypeSelect.setSelected(this.entityAttributes.getFurnitureType().getName());
        itemTypeSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String selectedTypeName = (String)itemTypeSelect.getSelected();
                FurnitureType selectedType = FurnitureViewerUI.this.furnitureTypeDictionary.getByName(selectedTypeName);
                FurnitureViewerUI.this.entityAttributes.setFurnitureType(selectedType);
                FurnitureViewerUI.this.entityAssetUpdater.updateEntityAssets(FurnitureViewerUI.this.currentEntity);
            }
        });
        this.containerTable.add(new Label((CharSequence)"Item Type:", this.uiSkin), itemTypeSelect);
    }

    private void createMaterialWidget(GameMaterialType materialType) {
        final SelectBox materialSelect = new SelectBox(this.uiSkin);
        Array<String> materialNames = new Array<String>();
        for (GameMaterial material : this.gameMaterialDictionary.getAll()) {
            if (!material.getMaterialType().equals((Object)materialType)) continue;
            materialNames.add(material.getMaterialName());
        }
        materialSelect.setItems(materialNames);
        materialSelect.setSelected(this.entityAttributes.getMaterials().get((Object)this.entityAttributes.getPrimaryMaterialType()).getMaterialName());
        materialSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String selectedMaterialName = (String)materialSelect.getSelected();
                GameMaterial selectedMaterial = FurnitureViewerUI.this.gameMaterialDictionary.getByName(selectedMaterialName);
                FurnitureViewerUI.this.entityAttributes.getMaterials().put(selectedMaterial.getMaterialType(), selectedMaterial);
            }
        });
        this.containerTable.add(new Label((CharSequence)(materialType.name() + " material:"), this.uiSkin), materialSelect);
    }

    public void render() {
        this.stage.act();
        this.stage.draw();
    }

    public void onResize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    public void updateAttributes(FurnitureEntityAttributes entityAttributes) {
        this.entityAttributes = entityAttributes;
    }

    private String colorToString(Color color) {
        return "#" + color.toString().substring(0, 6);
    }

    public Stage getStage() {
        return this.stage;
    }
}

